#include "audioinputdlg.h"
#include "ui_audioinputdlg.h"
#include "mainwindow.h"

AudioInputDlg::AudioInputDlg(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::AudioInputDlg)
{
    ui->setupUi(this);

    this->setMinimumSize(272, 237);

    this->setMaximumSize(272, 237);

    this->setWindowTitle("AUDIO INPUT");

    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    ULONG nChannelIndex = SC540dlg->m_nCurChannel;

    switch (SC540dlg->m_nAudioInput[ nChannelIndex ]) {
        case 0:
            ui->radioEMBEDDED_AUDIO->setChecked(true);
            break;
        case 1:
            ui->radioLINE_IN->setChecked(true);
            break;
        case 2:
            ui->radioSOUNDCARD_MIC->setChecked(true);
            break;
        case 3:
            ui->radioSOUNDCARD_LINE_IN->setChecked(true);
            break;
        default:
            break;
    }

}

AudioInputDlg::~AudioInputDlg()
{
    delete ui;
}

void AudioInputDlg::on_pushButton_ok_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    ULONG nChannelIndex = SC540dlg->m_nCurChannel;

    if( SC540dlg->m_hVideoDevice[ nChannelIndex ] != 0 ) {

        if( ui->radioEMBEDDED_AUDIO->isChecked() )
        {
            QCAP_SET_AUDIO_INPUT( SC540dlg->m_hVideoDevice[ nChannelIndex ], QCAP_INPUT_TYPE_EMBEDDED_AUDIO);
        }
        if( ui->radioLINE_IN->isChecked() )
        {
            QCAP_SET_AUDIO_INPUT( SC540dlg->m_hVideoDevice[ nChannelIndex ], QCAP_INPUT_TYPE_LINE_IN);
        }
        if( ui->radioSOUNDCARD_MIC->isChecked() )
        {
            QCAP_SET_AUDIO_INPUT( SC540dlg->m_hVideoDevice[ nChannelIndex ], QCAP_INPUT_TYPE_SOUNDCARD_MICROPHONE);
        }
        if( ui->radioSOUNDCARD_LINE_IN->isChecked() )
        {
            QCAP_SET_AUDIO_INPUT( SC540dlg->m_hVideoDevice[ nChannelIndex ], QCAP_INPUT_TYPE_SOUNDCARD_LINE_IN);
        }
    }
}
